##PROJECT_GLOBAL_BEGIN
[Programs]
Count=1

[Misc Info]
Author=Goran K
Company=Robotina
Version=1.0
EditTime=3238
CyProVersion=2.5.8

[Protection]
Level=0
Password=
##PROJECT_GLOBAL_END

##PROGRAM_BEGIN_1
#PROJECT_OPTIONS_BEGIN
[Program]
Name=eastron config

[VCP]
I2CPriority=5
SendSource=1
SendAlloc=1
ProtectWithPasswd=0
Password=
IORefresh=3
ScanOverrunStopsProgram=1
Com2Mode=3
HSCMode=0
EthAbusEnable=1
EthModbusEnable=0
WANUrl=
PushEvent=0
PushUrl=
ModbusBaudrate=19200
ModbusParity=0
ModbusStopBits=1
ModbusDelay=20
ModbusDeviceAddress=1
ModbusPLCDataModel=2
ModbusAddress=0
ModbusSlaveCount=1
ModbusRegisterCount=1
ModbusCoilsArrayVar=
ModbusRegistersArrayVar=
PLCCoilVars=
PLCRegisterVars=
ModbusCoilAddresses=
ModbusRegisterAddresses=

[Misc Info]
MonitorHistorySpeed=10

[Hardware]
CPUUnit=4
Card1=10
Type1=0
NAD1=46106
VarPrefix1=op00_
EventPriority1.2=8
EventPriority1.4=2
EventPriority1.5=2
EventPriority1.6=2
EventPriority1.7=2
EventPriority1.8=6
VarAreaTyp1.8.0=225
VarAreaTyp1.8.1=5
VarAreaTyp1.8.2=6

[Net]
MasterNAD=-1
PrgDevice00=9583
CurrentNAD=9583

[MonitorNet]
MasterNAD=-1

[Monitor01]
VarCount=11
VarName1=cybro_qx00
VarBase1=1
VarValue1=0
VarColor1=0
VarIndex1=0
VarName2=cybro_qx01
VarBase2=1
VarValue2=0
VarColor2=0
VarIndex2=1
VarName3=cybro_qx02
VarBase3=1
VarValue3=0
VarColor3=0
VarIndex3=2
VarName4=cybro_qx03
VarBase4=1
VarValue4=0
VarColor4=0
VarIndex4=3
VarName5=cybro_qx04
VarBase5=1
VarValue5=0
VarColor5=0
VarIndex5=4
VarName6=cybro_qx05
VarBase6=1
VarValue6=0
VarColor6=0
VarIndex6=5
VarName7=cybro_qx06
VarBase7=1
VarValue7=0
VarColor7=0
VarIndex7=6
VarName8=cybro_qx07
VarBase8=1
VarValue8=0
VarColor8=0
VarIndex8=7
VarName9=cybro_ix00
VarBase9=1
VarValue9=0
VarColor9=0
VarIndex9=8
VarName10=cybro_ix01
VarBase10=1
VarValue10=0
VarColor10=0
VarIndex10=9
VarName11=disconnect_inputs
VarBase11=1
VarValue11=0
VarColor11=0
VarIndex11=10

[Monitor02]
VarCount=11
VarName1=button_start
VarBase1=1
VarValue1=0
VarColor1=0
VarIndex1=0
VarName2=step
VarBase2=1
VarValue2=0
VarColor2=0
VarIndex2=1
VarName3=bps
VarBase3=1
VarValue3=0
VarColor3=0
VarIndex3=2
VarName4=address
VarBase4=1
VarValue4=0
VarColor4=0
VarIndex4=3
VarName5=mode
VarBase5=1
VarValue5=0
VarColor5=0
VarIndex5=4
VarName6=error_code
VarBase6=1
VarValue6=0
VarColor6=0
VarIndex6=5
VarName7=voltage
VarBase7=1
VarValue7=0
VarColor7=0
VarIndex7=6
VarName8=power_preset
VarBase8=1
VarValue8=0
VarColor8=0
VarIndex8=7
VarName9=cmd
VarBase9=1
VarValue9=0
VarColor9=0
VarIndex9=8
VarName10=chr_tout
VarBase10=1
VarValue10=0
VarColor10=0
VarIndex10=9
VarName11=msg_tout
VarBase11=1
VarValue11=0
VarColor11=0
VarIndex11=10
#PROJECT_OPTIONS_END

#DMVARSLIST_BEGIN
#DMVARSLIST_END

#MASKS_BEGIN
#MASKS_END

#CODE_BEGIN
// AllocGroupList="User Variables", "I/O Variables", "Constants", "eastron set"
var retain
  power_preset: int; default=5; // sec {AllocGroup="eastron set"}
  msg_tout: int; default=100; // {AllocGroup="eastron set"}
var_end;

var
  bps: int; // {AllocGroup="eastron set"}
  len: int; // {AllocGroup="eastron set"}
  par: int; // {AllocGroup="eastron set"}
  stp: int; // {AllocGroup="eastron set"}
  mode: int; // {AllocGroup="eastron set"}
  address: int; // {AllocGroup="eastron set"}
  warning: bool; // {AllocGroup="eastron set"}
  power: bool; // {AllocGroup="eastron set"}
  init: bool; // {AllocGroup="eastron set"}
  step: int; // {AllocGroup="eastron set"}
  button_start: bool; // {AllocGroup="eastron set"}
  cmd: int;
  power_timer: long; // {AllocGroup="eastron set"}
  load: bool; // {AllocGroup="eastron set"}
  indicator_ok: bool; // {AllocGroup="eastron set"}
  indicator_err: bool; // {AllocGroup="eastron set"}
  voltage: int; // {AllocGroup="eastron set"}
  error_code: int; // {AllocGroup="eastron set"}
  chr_tout: int; default=25; // {AllocGroup="eastron set"}
var_end;

function main:void; language 'Structured Text';
  function f_io_mux:void; language 'Structured Text';
  begin
    
    cybro_qx00 := warning or cybro_ix01;
    
    cybro_qx01 := power or cybro_ix01;
    
    cybro_qx02 := indicator_ok;
    cybro_qx03 := indicator_err;
    
    
    cybro_qx05 := load;
    
    button_start := cybro_ix00;
  end;
  function f_eastron_set:void; language 'Structured Text';
    function rx_to_real:real; language 'Structured Text';
    // AllocGroupList="User Variables"
    var
      x: long;
      l: long;
      r: real;
    var_end;

      function push_long(x:long):void; language 'Structured Text';
      // AllocGroupList="User Variables"
      var
        stack: long;
      var_end;

      begin
        
        stack := x;
        
      end;
      function pop_real:real; language 'Structured Text';
      // AllocGroupList="User Variables"
      var
        stack: real;
      var_end;

      begin
        
        result := stack;
        
      end;
      function pop_long:long; language 'Structured Text';
      // AllocGroupList="User Variables"
      var
        stack: long;
      var_end;

      begin
        
        result := stack;
        
      end;
    begin
      
      // read rx buffer 3..6, convert to real and return
      
      x:=16#1000000*word(rx_bufrd(3))+16#10000*word(rx_bufrd(4))+16#100*word(rx_bufrd(5))+word(rx_bufrd(6));
      l:=0;
      
      while l<>x do
        push_long(x); // write long to stack
        r:=pop_real(); // read real from stack
        l:=pop_long(); // read long from stack
      end_while; // repeat if corrupted
      
      result:=r;
      
    end;
  begin
    
    case step of
    
    // ****************************************************************************
    // Start
    // ****************************************************************************
    
      0 : // wait start button
        power := 0;
        warning := 0;
        load := 0;
        indicator_ok := 0;
        indicator_err := 0;
        error_code := 0;
        voltage := 0;
        bps := 1200;
        len := 8;
        par := 0;
        stp := 1;
        mode := 0;
        address := 0;
        if fp(button_start) or cmd > 0 then
          step := step + 1;
        end_if;
    
      1 : // power on SDM, wait
        power := 1;
        warning := 1;
        power_timer := power_timer + scan_time;
        if power_timer >= (long(power_preset) * 1000)  then
          power_timer := 0;
          step := step + 1;
        end_if;
    
    // ****************************************************************************
    // Search for SDM
    // ****************************************************************************
    
      2 : // bps read voltage from address 0
        com_init(bps,len,par,stp);
        dprns(0,0,0,'\00\03\00\12\00\02\65\DF');
        tx_start(8);
        step := step + 1;
    
      3: // send and start receive
        if !tx_active() then
          rx_start(0,0,9,msg_tout,chr_tout);
          step := step + 1;
        end_if;
    
      4: // test received message
        if !rx_active() then
          if rx_count()=9 then
            // OK
            address:=rx_bufrd(0); // read address
            mode := int(rx_to_real());
            step := step + 1;
          else
            par := par + 1;
            if par <= 2 then
              step := 2; // search with next parity
            else
              par := 0;
              stp := stp+1;
              if stp <= 2 then
                step := 2; // search with next stop
              else
                stp := 1;
                bps := bps * 2;
                if bps <= 9600 then
                  step := 2; // search with next speed
                else
                  step := 999; // not find
                end_if;
              end_if;
            end_if;
          end_if;
        end_if;
    
    // ****************************************************************************
    // configuration
    // ****************************************************************************
    
      5 : // set SDM to -SET- pres button
        if mode = 3 and address = 149 and bps = 9600 then
          step := 42;
        elsif fp(button_start) or cmd > 0 then
          step := step + 1;
        end_if;
    
      6 : // check configuration
        if mode <> 3 then
          step := 10;
        elsif address <> 149 then
          step := 20;
        elsif bps <> 9600 then
          step := 30;
        else
          step := 40;
        end_if;
    
    // ****************************************************************************
    // mode
    // ****************************************************************************
    
      10 : // set parity & stop
        com_init(bps,len,par,stp);
        dprns(0,0,0,'\00\10\00\12\00\02\04\40\40\00\00\63\92'); // set parity & stop bits to n2
        tx_start(13);
        step := step + 1;
    
      11 : // send and start receive
        if !tx_active() then
          rx_start(0,0,8,msg_tout,chr_tout);
          step := step + 1;
        end_if;
    
      12 : // test received message
        if !rx_active() then
          if rx_count()=8 then
            // OK
            error_code := 0;
            mode := 3;
            len := 8;
            par := 0;
            stp := 2;
            step := 6;
          else
            // error
            error_code := 1;
            step := 999;
          end_if;
        end_if;
    
    // ****************************************************************************
    // address
    // ****************************************************************************
    
      20 : // set address
        com_init(bps,len,par,stp);
        dprns(0,0,0,'\00\10\00\14\00\02\04\43\15\00\00\F3\EC'); // set modbus address to 149
        tx_start(13);
        step := step + 1;
    
      21 : // send and start receive
        if !tx_active() then
          rx_start(0,0,8,msg_tout,chr_tout);
          step := step + 1;
        end_if;
    
      22 : // test received message
        if !rx_active() then
          if rx_count()=8 then
            // OK
            error_code := 0;
            address := 149;
            step := 6;
          else
            // error
            error_code := 2;
            step := 999;
          end_if;
        end_if;
    
    // ****************************************************************************
    // speed
    // ****************************************************************************
    
      30 : // set bps
        com_init(bps,len,par,stp);
        dprns(0,0,0,'\00\10\00\1C\00\02\04\40\00\00\00\E3\CA'); // set baud rate to 9600
        tx_start(13);
        step := step + 1;
    
      31 : // send and start receive
        if !tx_active() then
          rx_start(0,0,8,msg_tout,chr_tout);
          step := step + 1;
        end_if;
    
      32: // test received message
        if !rx_active() then
          if rx_count()=8 then
            // OK
            bps := 9600;
            step := 6;
          else
            // error
            error_code := 3;
            step := 999;
          end_if;
        end_if;
    
    // ****************************************************************************
    // test - read voltage
    // ****************************************************************************
    
      40 : // power off - wait
        power := 0;
        power_timer := power_timer + scan_time;
        if power_timer >= (long(power_preset) * 1000)  then
          power_timer := 0;
          step := step + 1;
        end_if;
    
      41: // power on, wait
        power := 1;
        power_timer := power_timer + scan_time;
        if power_timer >= (long(power_preset) * 1000)  then
          power_timer := 0;
          step := step + 1;
        end_if;
    
      42: // read voltage
        com_init(9600,8,0,2);
        dprns(0,0,0,'\95\04\00\00\00\02\6D\1F'); // voltage [V]
        tx_start(8);
        step := step + 1;
    
      43: // send and start receive
        if !tx_active() then
          rx_start(0,0,9,msg_tout,chr_tout);
          step := step + 1;
        end_if;
    
      44: // test received message
        if !rx_active() then
          if rx_count()=9 then
            // OK
            voltage:=int(rx_to_real()); // read voltage [V]
            if voltage > 200 and voltage < 250 then
              step := 50;
            else
              // error
              error_code := 4;
              step := 999;
            end_if;
          else
            // error
            error_code := 5;
            step := 999;
          end_if;
        end_if;
    
      50 : // OK
        power := 0;
        warning := 1;
        load := 0;
        indicator_ok := 1;
        indicator_err := 0;
        if fp(button_start) or cmd > 0 then
          step := 0;
        end_if;
    
      999: // error
        power := 0;
        warning := 1;
        load := 0;
        indicator_ok := 0;
        indicator_err := 1;
        voltage := 0;
        bps := 0;
        len := 0;
        par := 0;
        stp := 0;
        if fp(button_start) or cmd > 0 then
          step := 0;
        end_if;
    
    end_case;
    
    cmd := 0;
  end;
  function f_op:void; language 'Structured Text';
  begin
    dclr(1);
    
    if step = 0 then
      // priklopi in pritisni tipko
      dprns(1,0,0,'priklopi stevec ');
      if clock_1s then
        dprns(1,0,1,'             P+F');
      else
        dprns(1,0,1,'                ');
      end_if;
      if fp(op00_key_f and op00_key_p) then
        cmd := 1;
      end_if;
    elsif step = 1 then
      // vklop
      dprns(1,0,0,'vklop stevca    ');
      if clock_1s then
        dprns(1,0,1,'             ...');
      else
        dprns(1,0,1,'                ');
      end_if;
    elsif step >= 2 and step <= 4 then
      // iskanje
      dprns(1,0,0,'iskanje stevca  ');
      dprns(1,0,1,'                ');
      dprnb(1,14,1,'o','O',clock_1s);
      dprnb(1,15,1,'O','o',clock_1s);
    elsif step = 5 then
      // postavi v -SEt-
      dprns(1,0,0,'drzi tipko      ');
      dprns(1,0,1,'stevca do SEt   ');
      dprnb(1,15,1,'F',' ',clock_1s);
      if fp(op00_key_f) then
        cmd := 1;
      end_if;
    elsif step >= 6 and step <= 39 then
      // konfiguracija
      dprns(1,0,0,'konfiguracija    ');
      dprns(1,0,1,'stevca           ');
      if clock_1s then
        dprns(1,0,1,'             ...');
      else
        dprns(1,0,1,'                ');
      end_if;
    elsif step >= 40 and step <= 49 then
      // testiranje
      dprns(1,0,0,'test stevca     ');
      if clock_1s then
        //           0123456789012345
        dprns(1,0,1,'             ...');
      else
        dprns(1,0,1,'                ');
      end_if;
    elsif step = 50 then
      // OK
      dprns(1,0,0,'    stevec OK    ');
      dprns(1,0,1,'                 ');
      dprnb(1,15,1,'F',' ',clock_1s);
      if fp(op00_key_f) then
        cmd := 1;
      end_if;
    elsif step = 999 then
      // err
      if clock_1s then
        dprns(1,0,0,'     NAPAKA     ');
      else
        dprns(1,0,0,'!!!  NAPAKA  !!!');
      end_if;
      dprns(1,0,1,'                 ');
      dprnb(1,15,1,'P',' ',clock_1s);
      if fp(op00_key_p) then
        cmd := 1;
      end_if;
    end_if;
  end;
begin
  
  f_io_mux();
  
  f_eastron_set();
  
  f_op();
end;
#CODE_END

#DESCRIPTION_BEGIN
#DESCRIPTION_END

##PROGRAM_END_1

